package gov.va.genisis2.ts.converter;


import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.ts.common.dto.UpdateResponseDTO;
import gov.va.genisis2.ts.service.impl.UpdateResponse;

/**
 * Converter to change update responses to DTOs
 * @author PII
 *
 */
@Component
public class UpdateResponseConverter implements Converter<UpdateResponse, UpdateResponseDTO> {

	@Override
	public UpdateResponseDTO convert(UpdateResponse source) {
		UpdateResponseDTO uR = new UpdateResponseDTO();
		
		uR.setQuery(source.getQuery());
		uR.setError(source.getError());
		uR.setDuplicate(source.getDuplicate());
		return uR;
	}


}
